
module Greedy where

import Point
import List

data (Ord a, Read a, Show a, (Show (Int,[Point a]))) =>
  Condition a = 
	  FindNew (Int,[Point a]) (Int,[Point a])
	| ItsOk (Int,[Point a]) (Int,[Point a])
	deriving (Eq,Read,Show)

----------------------------------------------------------------------------------------------------------------
greedy []	=	[]
greedy [p]	=	[p]
greedy ws	=	
  let	tour	=	doit (makeEdges ws) [] [] []
  in	if	( tour == [] )
	then	( error ("putz") )
	else	( head tour )

makeEdges [w]		=	[]
makeEdges (w:ws)	=	[ (dist2 w z, w , z) | z<-ws ] ++ makeEdges ws

doit [] tour _ _	=	tour
doit ((d,a,b):edges) tour gs1 gs2	=
  let
	newTour	(ga,sa) (gb,sb)		=	insertEdge a ga sa b gb sb tour
	upt (ga,sa) (gb,sb)		=	update a ga b gb gs1 gs2
  in
  case ( choose (a,b) tour gs1 gs2 ) of
		FindNew	ia ib		->	doit edges tour gs1 gs2
		ItsOk ia ib		->	doit edges (newTour ia ib) (fst(upt ia ib)) (snd(upt ia ib))

----------------------------------------------------------------------------------------------------------------
update a ga b gb gs1 gs2
	| ga==1 && gb==1	=	(gs1, [a,b]++gs2)
	| ga==1 		=	(b:gs1, a:gs2)
	| gb==1			=	(a:gs1, b:gs2)
	| otherwise		=	([a,b]++gs1, gs2)

choose (a,b) tour gs1 gs2
	| ga == 2 || gb == 2	=	FindNew (ga,sa) (gb,sb)		-- informacao relevante pqgreedy
	| sa==sb && ga/=0	=	FindNew (0,[]) (0,[])		-- informacao relevante pqgreedy
	| otherwise		=	ItsOk (ga,sa) (gb,sb)
  where	(ga,sa)			=	degree a gs1 gs2 tour
	(gb,sb)			=	degree b gs1 gs2 tour

degree a gs1 gs2 tour
	| elem a gs2	=	(2, sub2 a tour)
	| elem a gs1	=	(1, sub1 a tour)
	| otherwise	=	(0,[])

sub1 a []				=	[]
sub1 a (w:ws)
	| (head w == a)||(last w == a)	=	w
	| otherwise			=	sub1 a ws
sub2 a []				=	[]
sub2 a (w:ws)
	| elem a w			=	w
	| otherwise			=	sub2 a ws

insertEdge a ga sa b gb sb tour 
	| ga==1 && gb==1	=	mergeTours a sa b sb tour
	| ga==1			=	mergeHead a sa b tour
	| gb==1			=	mergeHead b sb a tour
	| otherwise		=	[a,b]:tour
	
mergeHead x sx y tour
	| isHead x sx		=	([y]++sx):subtour
	| otherwise		=	(sx++[y]):subtour
  where	subtour			=	List.delete sx tour

mergeTours a sa b sb tour
	| isHead a sa && isHead b sb	=	((reverse sb)++sa):subtour
	| isHead a sa			=	(sb++sa):subtour
	| isHead b sb			=	(sa++sb):subtour
	| otherwise			=	((reverse sa)++sb):subtour
  where subtour				=	List.delete sa (List.delete sb tour)

isHead x []	=	False
isHead x (a:xs)	=	x==a

--------------------------------------------------------------------------------------------------------

dist2 (a,b) (c,d)	=	(a-c)*(a-c) + (b-d)*(b-d)

qs [] = []
qs ((d,x,y):ys) = (qs (split (>) (d,x,y) ys) ++
 		((d,x,y): (qs (split (<=) (d,x,y) ys))))
 
split op a [] = []
split op (d,x,y) ((d1,x1,y1):xs)
 	|op d d1    = (d1,x1,y1):(split op (d,x,y) xs)
 	|otherwise  = (split op (d,x,y) xs)
